﻿//////////////////////////////////////////////
// StructToString.h
//
//////////////////////////////////////////////

/// Defines / Macros -------------------------

#pragma once

/// Forward decl -----------------------------

namespace nkGraphics
{
	enum class PASS_TYPE ;
	enum class RESOURCE_TYPE ;
	enum class TEXTURE_RENDER_FLAG ;
}

/// Includes ---------------------------------

// nkGraphics
#include "../Buffers/Enums/BufferBindFlag.h"
#include "../Buffers/Enums/BufferCpuAccessFlag.h"
#include "../Buffers/Enums/BufferUsage.h"

#include "../Dll/DllDefines.h"

#include "../Resources/Enums/ResourceMiscFlag.h"

#include "DxDefinesWrapper.h"

// nkMemory
#include <NilkinsMemory/Containers/StringView.h>
	
/// Class ------------------------------------

namespace nkGraphics
{
	class DLL_GRAPHICS_EXPORT StructToString
	{
		public :
		
			// Shader type to string
			static nkMemory::StringView getShaderTypeString (SHADER_TYPE val) ;
			static SHADER_TYPE getStringShaderType (nkMemory::StringView str) ;

			// Shader Semantic
			static nkMemory::StringView getShaderSemanticString (SHADER_SEMANTIC val) ;
			static SHADER_SEMANTIC getStringShaderSemantic (nkMemory::StringView str) ;

			// Program profile
			static nkMemory::StringView getProgramProfileString (PROGRAM_COMPILATION_PROFILE val) ;
			static PROGRAM_COMPILATION_PROFILE getStringProgramProfile (nkMemory::StringView str) ;

			// Blend
			static nkMemory::StringView getBlendString (BLEND val) ;
			static BLEND getStringBlend (nkMemory::StringView str) ;
			static BLEND getBlendFromIndex (unsigned int index) ;

			// Blend Op
			static nkMemory::StringView getBlendOpString (BLEND_OP val) ;
			static BLEND_OP getStringBlendOp (nkMemory::StringView str) ;
			static BLEND_OP getBlendOpFromIndex (unsigned int index) ;

			// Write mask
			static nkMemory::StringView getWriteMaskString (COLOR_WRITE_ENABLE val) ;
			static COLOR_WRITE_ENABLE getStringWriteMask (nkMemory::StringView str) ;
			static COLOR_WRITE_ENABLE getWriteMaskFromIndex (unsigned int index) ;

			// Depth write mask
			static nkMemory::StringView getDepthWriteMaskString (DEPTH_WRITE_MASK val) ;
			static DEPTH_WRITE_MASK getStringDepthWriteMask (nkMemory::StringView str) ;
			static DEPTH_WRITE_MASK getDepthWriteMaskFromIndex (unsigned int index) ;

			// Stencil op
			static nkMemory::StringView getStencilOpString (STENCIL_OP val) ;
			static STENCIL_OP getStringStencilOp (nkMemory::StringView str) ;
			static STENCIL_OP getStencilOpFromIndex (unsigned int index) ;

			// Fill mode
			static nkMemory::StringView getFillModeString (FILL_MODE val) ;
			static FILL_MODE getStringFillMode (nkMemory::StringView str) ;
			static FILL_MODE getFillModeFromIndex (unsigned int index) ;

			// Cull Mode
			static nkMemory::StringView getCullModeString (CULL_MODE val) ;
			static CULL_MODE getStringCullMode (nkMemory::StringView str) ;
			static CULL_MODE getCullModeFromIndex (unsigned int index) ;

			// Usage
			static nkMemory::StringView getUsageString (BUFFER_USAGE val) ;
			static BUFFER_USAGE getStringUsage (nkMemory::StringView str) ;
			static BUFFER_USAGE getUsageFromIndex (unsigned int index) ;

			// Format
			static nkMemory::StringView getFormatString (FORMAT val) ;
			static FORMAT getStringFormat (nkMemory::StringView str) ;
			static FORMAT getFormatFromIndex (unsigned int index) ;

			// Bind Flag
			static nkMemory::StringView getBindFlagString (BUFFER_BIND_FLAG val) ;
			static BUFFER_BIND_FLAG getStringBindFlag (nkMemory::StringView str) ;
			static BUFFER_BIND_FLAG getBindFlagFromIndex (unsigned int index) ;

			// CPU Access Flag
			static nkMemory::StringView getCpuAccessFlagString (BUFFER_CPU_ACCESS_FLAG val) ;
			static BUFFER_CPU_ACCESS_FLAG getStringCpuAccessFlag (nkMemory::StringView str) ;
			static BUFFER_CPU_ACCESS_FLAG getCpuAccessFlagFromIndex (unsigned int index) ;

			// Misc Flags
			static nkMemory::StringView getMiscFlagString (RESOURCE_MISC_FLAG val) ;
			static RESOURCE_MISC_FLAG getStringMiscFlag (nkMemory::StringView str) ;
			static RESOURCE_MISC_FLAG getMiscFlagFromIndex (unsigned int index) ;

			// Pass type
			static nkMemory::StringView getPassTypeString (PASS_TYPE val) ;
			static PASS_TYPE getStringPassType (nkMemory::StringView str) ;

			// Resource type
			static nkMemory::StringView getResourceTypeString (RESOURCE_TYPE val) ;
			static RESOURCE_TYPE getStringResourceType (nkMemory::StringView str) ;

			// Texture render flag
			static nkMemory::StringView getTexRenderFlagString (TEXTURE_RENDER_FLAG val) ;
			static TEXTURE_RENDER_FLAG getStringTexRenderFlag (nkMemory::StringView str) ;
	} ;
}